
void UART_Task() {
  unsigned long tmpTimeTickNow = millis();
  //Receive time out
  if (g_InputStatus != INPUT_STATUS_IDEL) {
    if (tmpTimeTickNow > g_Uart_Input_TimeSpan) {
      if (tmpTimeTickNow - g_Uart_Input_TimeSpan >= g_UART_INPUT_TIMEOUT_MAX ) {
        Reset_InputBuffer();
      }
    }
    else {
      g_Uart_Input_TimeSpan = tmpTimeTickNow;
    }
  }
  //Receive Completed
  if (g_InputStatus == INPUT_STATUS_RCVCOMPLETED ) {
    g_InputAdd = g_StrInput_Add.toInt();
    UART_Process ( g_StrInputString , g_StrInput_Cmd , g_InputAdd, g_StrInput_Para1, g_StrInput_Para2) ;
    Reset_InputBuffer();
  }
}

void Reset_InputBuffer() {
  g_StrInputString  = "";   //used to store the whold input string without newline
  g_StrInput_Cmd    = "" ;
  g_StrInput_Add    = "" ;
  g_StrInput_Para1  = "" ;
  g_StrInput_Para2  = "" ;
  g_InputStatus = INPUT_STATUS_IDEL ;
  digitalWrite( 13 , LOW );
}

void RS485_SentString(String sentStr) {
  digitalWrite( 24 , HIGH );
  Serial.print(sentStr);
  Serial.flush();
  delay(1);
  digitalWrite( 24 , LOW );
}


void RS485_SentStringLn(String sentStr) {
  digitalWrite( 24 , HIGH );
  Serial.println(sentStr);
  Serial.flush();
  delay(1);
  digitalWrite( 24 , LOW );
}

// 0x3D: "="
// 0x20: " " // Space
// 0x3A: ":"
void serialEvent() {
  while (Serial.available()) {
    g_Uart_Input_TimeSpan = millis() ;
    char inChar = (char)Serial.read();
 
    switch ( g_InputStatus ) {
      case INPUT_STATUS_IDEL:
        if ( inChar != 0x0A && inChar != 0x0D ) {
          g_StrInputString += inChar ;
          g_StrInput_Cmd += inChar ;
          g_InputStatus = INPUT_STATUS_CMD ;
        }
        else {
          Reset_InputBuffer();
        }
        break;

      case INPUT_STATUS_CMD :
        digitalWrite( 13 , HIGH );
        if ( inChar != 0x0A && inChar != 0x0D ) {
          g_StrInputString += inChar ;
          if ( inChar != 0x3A) {
            g_StrInput_Cmd += inChar ;
          }
        }
        else {
          Reset_InputBuffer();
        }
        if ( inChar ==  0x3A ) g_InputStatus = INPUT_STATUS_ADD ;
        break ;

      case INPUT_STATUS_ADD:
        if ( inChar != 0x0A && inChar != 0x0D ) {
          g_StrInputString += inChar ;
          if ( inChar != 0x3A) {
            g_StrInput_Add += inChar ;
          }
        }
        else {
          g_InputStatus = INPUT_STATUS_RCVCOMPLETED;
        }
        if ( inChar ==  0x3A ) g_InputStatus = INPUT_STATUS_PARA1 ;
        break;

      case INPUT_STATUS_PARA1 :
        if ( inChar != 0x0A && inChar != 0x0D ) {
          g_StrInputString += inChar ;
          if ( inChar != 0x3A) {
            g_StrInput_Para1 += inChar ;
          }
        }
        else {
          g_InputStatus = INPUT_STATUS_RCVCOMPLETED;
        }
        if ( inChar ==  0x3A ) g_InputStatus = INPUT_STATUS_PARA2 ;
        break ;

      case  INPUT_STATUS_PARA2:
        if ( inChar != 0x0A && inChar != 0x0D ) {
          g_StrInputString += inChar ;
          g_StrInput_Para2 += inChar ;
        }
        else {
          g_InputStatus = INPUT_STATUS_RCVCOMPLETED;
        }
        break ;

      case INPUT_STATUS_RCVCOMPLETED:

        break;

      default:
        Reset_InputBuffer();
        break ;
    }
  }
}

void UART_Process ( String StrInputString , String StrCMD, int inputAdd, String StrPARA1, String StrPARA2 ) {
  String TempStringForReply = "" ;
  String TempStrCMD = StrCMD ;
  String TempStrPARA1 = StrPARA1 ;
  String TempStrPARA2 = StrPARA2 ;
  TempStrCMD.trim() ;
  TempStrCMD.toUpperCase();

  TempStrPARA1.toUpperCase();
  TempStrPARA1.trim();

  TempStrPARA2.toUpperCase();
  TempStrPARA2.trim();


  //--CMD: SEARCH -----------------------------------------
  if ( TempStrCMD.equals( "SEARCH" )) {
    if ( inputAdd == g_Hardware_RS485_Add) {
      TempStringForReply = StrInputString + "=" + g_Model_Name_Form_Eeprom ;
      RS485_SentStringLn ( TempStringForReply ) ;
    }
    return ;
  }

  //--CMD: JUMP -----------------------------------------
  if ( TempStrCMD.equals( "JUMP" )) {
    if ( inputAdd == g_Hardware_RS485_Add) {
      TempStringForReply = StrInputString + "=" + "OK" ;
      RS485_SentStringLn ( TempStringForReply ) ;
      delay(2);
      GoToBoot();
    }
    return ;
  }

  //--CMD: TEST -----------------------------------------
  if ( TempStrCMD.equals( "TEST" )) {
    if ( inputAdd == g_Hardware_RS485_Add) {
      RS485_SentString ( "StrInputString = " ) ; RS485_SentStringLn ( StrInputString ) ;
      RS485_SentString ( "TempStrCMD     = " ) ; RS485_SentStringLn ( TempStrCMD ) ;
      RS485_SentString ( "inputAdd       = " ) ; RS485_SentStringLn ( String(inputAdd )) ;
      RS485_SentString ( "TempStrPARA1   = " ) ; RS485_SentStringLn ( TempStrPARA1 ) ;
      RS485_SentString ( "TempStrPARA2   = " ) ; RS485_SentStringLn ( TempStrPARA2 ) ;
      RS485_SentStringLn ( "" ) ;
    }
    return ;
  }

  //--CMD: Add your command here-----------------------
}
